/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
Mshg       terrain        ; // terrain mesh
Grass      grass          ; // grass   renderer
Grass::Elm grass_elm[4096]; // single grass element
/******************************************************************************/
void InitPre()
{
   App.name="Grass";
   App.flag=APP_MS_EXCLUSIVE|APP_FULL_TOGGLE;
   IOPath="../data/";
   PakAdd("engine.pak");

   D.full(true).sync(true).ambPower(0.3).shdMapSize(1024);
   ViewportFull.range=50;
}
/******************************************************************************/
Bool Init()
{
   Cam.dist=6;
   Cam.at.set(0,2,0);
   Sun.set(*Gfxs("gfx/sky/sun.gfx")); // sun
   Sky.set();                         // sky

   // load terrain mesh
   terrain.load("obj/terrain/0.mshg");

   // create grass renderer
   grass.create();

   // set random grass matrixes
   terrain.setFaceNormals(); // make sure terrain has face normals, since we'll need those later
   REPA(grass_elm)
   {
      Grass::Elm &elm   =grass_elm[i];
      Matrix     &matrix=elm.matrix;
                         elm.param.set(0,0,0,255); // set parameters

      matrix.setScale(Vec(0.18,0.3,0.18)).rotateY(RndF(PI2)); // set scaled matrix and rotate it

      Vec start=Rnd(terrain.box);    // set random position at top of the terrain mesh box
          start.y=terrain.box.max.y;

      I32 hit_face,hit_mshb,hit_mesh;
      if(CutsPOINTMesh(start,-Vec(0,terrain.box.h(),0),terrain,NULL,NULL,&matrix.pos,&hit_face,&hit_mshb,&hit_mesh)) // cast a ray down-wards and store contact info
      {
         Mshb &mshb=terrain.M(hit_mesh).B(hit_mshb);                                                   // this is the Mshb that we've hit
         Vec  &nrm =((hit_face&SIGN_BIT) ? mshb.quad.nrm[hit_face^SIGN_BIT] : mshb.tri.nrm[hit_face]); // this is the face normal that we've hit
         matrix.orn*=Matrix3().setUp(nrm);                                                             // transform our grass matrix according to surface normal
         matrix.pos.y-=0.05;                                                                           // move it down a little
      }
   }

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   CamHandle(0.1,100,CAMH_ZOOM|(Ms.b(1)?CAMH_MOVE:CAMH_ROT)); // move camera on right mouse button
   UpdateGrassAndLeafs(); // update grass bending
   return true;
}
/******************************************************************************/
void Render()
{
   switch(Renderer())
   {
      case RM_SHD_MAP:
      case RM_SOLID  :
         terrain.draw(MatrixIdentity);          // render terrain
         grass.draw(grass_elm,ELMS(grass_elm)); // render grass
      break;
   }
}
void Draw()
{
   Renderer(Render);
}
/******************************************************************************/
